IF EXISTS (
		SELECT *
		FROM SYS.PROCEDURES
		WHERE NAME = 'P_INCLUI_PRECO_FAMILIA'
		)
BEGIN
	DROP PROCEDURE P_INCLUI_PRECO_FAMILIA;
END;
GO

CREATE PROCEDURE [dbo].[P_INCLUI_PRECO_FAMILIA] (@CD_ALT_PRECO INT)
AS
SET NOCOUNT ON

/*
=======================================================================================
'Job.................: Linx - Atualizacao de precos
'Função..............: Altera o preco de produtos baseado na familia do primeiro do grupo (CD_ALT_PRECO).  1 O produto - Origem_preco = 0 Outros produtos - Origem_preco = 1
'Objetivo............:  
'Tabelas.............: 
'Dt Modificação......: 26/12/2023
'Modificação.........: Refatoração da Procedure devido a que atendia somente a primeira familia de produtos...
'=======================================================================================
*/
DECLARE @CD_FAMILIA INT
	,@CD_PROD INT
	,@VLR_TABELA MONEY
	,@VLR_OFERTA MONEY
DECLARE @DT_REF DATE

SET @DT_REF = GETDATE()

IF @CD_ALT_PRECO IS NOT NULL
BEGIN
	DECLARE T1 CURSOR
	FOR
	SELECT DISTINCT ARV.CD_ARV_MERC_FAMILIA AS CD_FAMILIA
		,C.VLR_TABELA
		,C.VLR_OFERTA
	FROM EST_PROD_EST_ARV_MERCADOLOGICA ARV
	INNER JOIN EST_PROD_PRECO_ALT_CPL C ON C.CD_EMP = ARV.CD_EMP
		AND C.CD_PROD = ARV.CD_PROD
	WHERE C.CD_EMP = 1
		AND C.CD_ALT_PRECO = @CD_ALT_PRECO
		AND ARV.CD_ARV_MERC_FAMILIA > 0

	OPEN T1;

	FETCH NEXT
	FROM T1
	INTO @CD_FAMILIA
		,@VLR_TABELA
		,@VLR_OFERTA;

	WHILE @@FETCH_STATUS = 0
	BEGIN
		PRINT 'CD_ALT_PRECO : ' + CONVERT(VARCHAR(50), @CD_ALT_PRECO)
		PRINT 'CD_FAMILIA : ' + CONVERT(VARCHAR(50), @CD_FAMILIA)

		---------------------------------------------------------------------------------------------------------------------------
		/* Insere os produtos com o novo preco */
		---------------------------------------------------------------------------------------------------------------------------
		INSERT INTO EST_PROD_PRECO_ALT_CPL
		SELECT DISTINCT ARV_MERC.CD_EMP
			,A.CD_ALT_PRECO
			,ARV_MERC.CD_PROD
			,@VLR_TABELA
			,@VLR_OFERTA
			,A.VLR_CUSTO
			,A.CD_FILIAL
			,A.CD_NF
			,A.TP_NIVEL_PERC
			,A.PERC_MARGEM
			,A.DS_PERC_MARGEM
			,A.TP_CUSTO
			,A.DS_TP_CUSTO
			,A.VLR_TABELA_ORIGINAL
			,A.VLR_TABELA_VIGENTE
			,A.VLR_OFERTA_VIGENTE
			,A.CD_ALT_PRECO_ANTERIOR
			,A.PERC_VARIACAO_AUMENTO
			,1 AS ORIGEM_PRECO
		FROM EST_PROD_EST_ARV_MERCADOLOGICA ARV_MERC
		JOIN EST_PROD_PRECO_ALT_CPL A ON A.CD_EMP = ARV_MERC.CD_EMP
			AND ARV_MERC.CD_ARV_MERC_FAMILIA = @CD_FAMILIA
		WHERE A.CD_EMP = 1
			AND A.CD_ALT_PRECO = @CD_ALT_PRECO
			AND ARV_MERC.CD_PROD NOT IN (
				SELECT X.CD_PROD
				FROM EST_PROD_PRECO_ALT_CPL X
				WHERE X.CD_EMP = ARV_MERC.CD_EMP
					AND X.CD_ALT_PRECO = A.CD_ALT_PRECO
					AND X.CD_PROD = ARV_MERC.CD_PROD
				);

		FETCH NEXT
		FROM T1
		INTO @CD_FAMILIA
			,@VLR_TABELA
			,@VLR_OFERTA
	END

	CLOSE T1;

	DEALLOCATE T1;
END
ELSE
BEGIN
	DECLARE C1 CURSOR
	FOR
	SELECT DISTINCT EST_PROD_PRECO_ALT.CD_ALT_PRECO
	FROM EST_PROD_PRECO_ALT
	INNER JOIN EST_PROD_PRECO_ALT_CPL ON EST_PROD_PRECO_ALT.CD_EMP = EST_PROD_PRECO_ALT_CPL.CD_EMP
		AND EST_PROD_PRECO_ALT.CD_ALT_PRECO = EST_PROD_PRECO_ALT_CPL.CD_ALT_PRECO
	WHERE EST_PROD_PRECO_ALT.APLICADO IN (0, 2)
		AND EST_PROD_PRECO_ALT.CD_EMP = 1
		AND ISNULL(EST_PROD_PRECO_ALT.DT_AGENDADA, '20000101') <= @DT_REF
		AND EST_PROD_PRECO_ALT.APLICAR_PRECO_FAMILIA = 1

	OPEN C1;

	FETCH NEXT
	FROM C1
	INTO @CD_ALT_PRECO;

	WHILE @@FETCH_STATUS = 0
	BEGIN
		DECLARE T1 CURSOR
		FOR
		SELECT DISTINCT ARV.CD_ARV_MERC_FAMILIA AS CD_FAMILIA
			,C.VLR_TABELA
			,C.VLR_OFERTA
		FROM EST_PROD_EST_ARV_MERCADOLOGICA ARV
		INNER JOIN EST_PROD_PRECO_ALT_CPL C ON C.CD_EMP = ARV.CD_EMP
			AND C.CD_PROD = ARV.CD_PROD
		WHERE C.CD_EMP = 1
			AND C.CD_ALT_PRECO = @CD_ALT_PRECO
			AND ARV.CD_ARV_MERC_FAMILIA > 0

		OPEN T1;

		FETCH NEXT
		FROM T1
		INTO @CD_FAMILIA
			,@VLR_TABELA
			,@VLR_OFERTA;

		WHILE @@FETCH_STATUS = 0
		BEGIN
			PRINT 'CD_ALT_PRECO : ' + CONVERT(VARCHAR(50), @CD_ALT_PRECO)
			PRINT 'CD_FAMILIA : ' + CONVERT(VARCHAR(50), @CD_FAMILIA)

			---------------------------------------------------------------------------------------------------------------------------
			/* Insere os produtos com o novo preco */
			---------------------------------------------------------------------------------------------------------------------------
			INSERT INTO EST_PROD_PRECO_ALT_CPL
			SELECT DISTINCT ARV_MERC.CD_EMP
				,A.CD_ALT_PRECO
				,ARV_MERC.CD_PROD
				,@VLR_TABELA
				,@VLR_OFERTA
				,A.VLR_CUSTO
				,A.CD_FILIAL
				,A.CD_NF
				,A.TP_NIVEL_PERC
				,A.PERC_MARGEM
				,A.DS_PERC_MARGEM
				,A.TP_CUSTO
				,A.DS_TP_CUSTO
				,A.VLR_TABELA_ORIGINAL
				,A.VLR_TABELA_VIGENTE
				,A.VLR_OFERTA_VIGENTE
				,A.CD_ALT_PRECO_ANTERIOR
				,A.PERC_VARIACAO_AUMENTO
				,1 AS ORIGEM_PRECO
			FROM EST_PROD_EST_ARV_MERCADOLOGICA ARV_MERC
			JOIN EST_PROD_PRECO_ALT_CPL A ON A.CD_EMP = ARV_MERC.CD_EMP
				AND ARV_MERC.CD_ARV_MERC_FAMILIA = @CD_FAMILIA
			WHERE A.CD_EMP = 1
				AND A.CD_ALT_PRECO = @CD_ALT_PRECO
				AND ARV_MERC.CD_PROD NOT IN (
					SELECT X.CD_PROD
					FROM EST_PROD_PRECO_ALT_CPL X
					WHERE X.CD_EMP = ARV_MERC.CD_EMP
						AND X.CD_ALT_PRECO = A.CD_ALT_PRECO
						AND X.CD_PROD = ARV_MERC.CD_PROD
					);

			FETCH NEXT
			FROM T1
			INTO @CD_FAMILIA
				,@VLR_TABELA
				,@VLR_OFERTA
		END

		CLOSE T1;

		DEALLOCATE T1;

		FETCH NEXT
		FROM C1
		INTO @CD_ALT_PRECO
	END

	CLOSE C1;

	DEALLOCATE C1;
END
